// WatkiSynchronizacjaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WatkiSynchronizacja.h"
#include "WatkiSynchronizacjaDlg.h"
#include "UIThread.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CWatkiSynchronizacjaDlg dialog

CWatkiSynchronizacjaDlg::firma fm;    
CRITICAL_SECTION g_cs;

CWatkiSynchronizacjaDlg::CWatkiSynchronizacjaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWatkiSynchronizacjaDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWatkiSynchronizacjaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CWatkiSynchronizacjaDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
    ON_WM_NCDESTROY()
    ON_BN_CLICKED(IDC_BUTTON1, &CWatkiSynchronizacjaDlg::OnBnClickedButton1)
    ON_BN_CLICKED(IDC_BUTTON2, &CWatkiSynchronizacjaDlg::OnBnClickedButton2)
END_MESSAGE_MAP()


// CWatkiSynchronizacjaDlg message handlers

BOOL CWatkiSynchronizacjaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

    // Inicjalizacja sekcji krytycznej
    InitializeCriticalSection(&g_cs);
    
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWatkiSynchronizacjaDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWatkiSynchronizacjaDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CWatkiSynchronizacjaDlg::OnNcDestroy()
{
    CDialog::OnNcDestroy();

    // TODO: Add your message handler code here
    DeleteCriticalSection(&g_cs);
    // Zabijamy wszystkie oczekujace wtki
    TerminateProcess(GetCurrentProcess(), -1);
}

UINT WriteThread(LPVOID pParam)
{
    EnterCriticalSection(&g_cs);
    wchar_t t1[30], t2[10];    
    HWND hWnd = FindWindow(NULL, L"WatkiSynchronizacja");
        
    if(!GetDlgItemTextW(hWnd, IDC_EDIT1, (LPWSTR)&t1, 30) || 
        !GetDlgItemTextW(hWnd, IDC_EDIT2, (LPWSTR)&t2, 10))
        AfxThrowMemoryException();
    else
    {    
        fm.nazwa = t1;
        fm.obrot = _wtof(t2);
        Sleep(5000);        
    }        
    
    LeaveCriticalSection(&g_cs);
    return 0;
}

void CWatkiSynchronizacjaDlg::OnBnClickedButton1()
{   
    if(TryEnterCriticalSection(&g_cs))
    {
        LeaveCriticalSection(&g_cs);
        CWinThread *pThread = AfxBeginThread(WriteThread, NULL);
    }    
    else
        AfxMessageBox(L"Nie mona dokona zapisu.");
}

void CWatkiSynchronizacjaDlg::OnBnClickedButton2()
{
    if(!TryEnterCriticalSection(&g_cs))
        AfxMessageBox(L"Nie mona odczyta danych. Trwa zapis...");
    else
    {
        //AfxMessageBox(L"Mona czyta dane");
        CWinThread *pThread = AfxBeginThread(RUNTIME_CLASS(CUIThread));
        LeaveCriticalSection(&g_cs);
    }        
}

